% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_tree.R
\name{make_tree}
\alias{make_tree}
\title{Generate a Transmission Tree}
\usage{
make_tree(n_cases, R = 2, stochastic = FALSE, plot = FALSE)
}
\arguments{
\item{n_cases}{Integer. The total number of cases (nodes) in the tree.}

\item{R}{Integer. The fixed number of branches per case when \code{stochastic} is \code{FALSE},
or the mean of the Poisson distribution when \code{stochastic} is \code{TRUE}.}

\item{stochastic}{Logical. If \code{TRUE}, the number of branches per case is sampled from
a Poisson distribution with mean \code{R}. Default is \code{FALSE}.}

\item{plot}{Logical. If \code{TRUE}, the function will plot the generated tree. Default is \code{FALSE}.}
}
\value{
An igraph object representing the transmission tree.
}
\description{
Creates a transmission tree with a specified number of cases and branches per case.
The tree can be generated with fixed or Poisson-distributed branching factors.
}
\examples{
# Generate a deterministic transmission tree
deterministic_tree <- make_tree(n_cases = 15, R = 2, stochastic = FALSE, plot = TRUE)

# Generate a stochastic transmission tree
random_tree <- make_tree(n_cases = 15, R = 2, stochastic = TRUE, plot = TRUE)
}
