% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_test.R
\name{tree_test}
\alias{tree_test}
\title{Test Differences Between Sets of Transmission Trees}
\usage{
tree_test(
  ...,
  method = c("permanova", "chisq", "fisher"),
  within_dist = patristic,
  between_dist = euclidean,
  test_args = list()
)
}
\arguments{
\item{...}{Two or more sets of transmission trees. Each set must be a list of data frames with columns \code{from} (infector) and \code{to} (infectee).}

\item{method}{A character string specifying the test method. Options are \code{"permanova"}, #' \code{"chisq"}, or \code{"fisher"}. Default is \code{"permanova"}.}

\item{within_dist}{A function to compute pairwise distances within a tree for PERMANOVA. Takes a data frame, returns a square matrix. Default is \code{\link{patristic}}.}

\item{between_dist}{A function to compute distance between two trees for PERMANOVA. Takes two matrices, returns a numeric value. Default is \code{\link{euclidean}}.}

\item{test_args}{A list of additional arguments to pass to the underlying test function (\code{vegan::adonis2}, \code{stats::chisq.test}, or \code{stats::fisher.test}). Default is an empty list.}
}
\value{
\itemize{
\item For \code{"permanova"}: A \code{"vegan::adonis2"} object containing the test results.
\item For \code{"chisq"} or \code{"fisher"}: An \code{"htest"} object with the test results.
}
}
\description{
Performs a statistical test to assess whether there are significant differences between sets of transmission trees.
Supports PERMANOVA (via \code{"vegan::adonis2"}), Chi-Square, or Fisher's Exact Test.
}
\details{
This function compares sets of transmission trees using one of three statistical tests.

\strong{PERMANOVA}: Evaluates whether the topology of transmission trees differs between sets.
\itemize{
\item \strong{Null Hypothesis (H0)}: There is no difference in tree topologies between sets.
\item \strong{Alternative Hypothesis (H1)}: At least one set of transmission trees has a different topological structure.
}

\strong{Chi-Square or Fisher’s Exact Test}: Evaluates whether the distribution of infector-infectee pairs differs between sets.
\itemize{
\item \strong{Null Hypothesis (H0)}: The frequency of infector-infectee pairs is consistent across all sets.
\item \strong{Alternative Hypothesis (H1)}: The frequency of infector-infectee pairs differs between at least two sets.
}
}
\examples{
set.seed(1)
# Generate example sets
setA <- replicate(10, igraph::as_long_data_frame(
  make_tree(n_cases = 10, R = 2, stochastic = TRUE)
), simplify = FALSE)
setB <- replicate(10, igraph::as_long_data_frame(
  make_tree(n_cases = 10, R = 2, stochastic = TRUE)
), simplify = FALSE)
setC <- replicate(10, igraph::as_long_data_frame(
  make_tree(n_cases = 10, R = 4, stochastic = TRUE)
), simplify = FALSE)

# PERMANOVA test
tree_test(setA, setB, setC,  method = "permanova")

# Chi-Square test
tree_test(setA, setB, setC, method = "chisq")
}
\seealso{
\code{\link{permanova_test}}, \code{\link{chisq_test}}
}
