% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/steady.R
\name{projectToSteady}
\alias{projectToSteady}
\title{Project to steady state}
\usage{
projectToSteady(
  params,
  effort = params@initial_effort,
  distance_func = distanceSSLogN,
  t_per = 1.5,
  t_max = 100,
  dt = 0.1,
  tol = 0.1 * t_per,
  return_sim = FALSE,
  progress_bar = TRUE,
  ...
)
}
\arguments{
\item{params}{A \linkS4class{MizerParams} object}

\item{effort}{The fishing effort to be used throughout the simulation.
This must be a vector or list with one named entry per fishing gear.}

\item{distance_func}{A function that will be called after every \code{t_per} years
with both the previous and the new state and that should return a number
that in some sense measures the distance between the states. By default
this uses the function \code{\link[=distanceSSLogN]{distanceSSLogN()}} that you can use as a model for your
own distance function.}

\item{t_per}{The simulation is broken up into shorter runs of \code{t_per} years,
after each of which we check for convergence. Default value is 1.5. This
should be chosen as an odd multiple of the timestep \code{dt} in order to be
able to detect period 2 cycles.}

\item{t_max}{The maximum number of years to run the simulation. Default is 100.}

\item{dt}{The time step to use in \code{project()}.}

\item{tol}{The simulation stops when the relative change in the egg
production RDI over \code{t_per} years is less than \code{tol} for every species.}

\item{return_sim}{If TRUE, the function returns the MizerSim object holding
the result of the simulation run, saved at intervals of \code{t_per}. If FALSE (default) the function returns
a MizerParams object with the "initial" slots set to the steady state.}

\item{progress_bar}{A shiny progress object to implement a progress bar in a
shiny app. Default FALSE.}

\item{...}{Further arguments will be passed on to your distance function.}
}
\value{
A MizerParams or a MizerSim object
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Run the full dynamics, as in \code{\link[=project]{project()}}, but stop once the change has slowed
down sufficiently, in the sense that the distance between states at
successive time steps is less than \code{tol}. You determine how the distance is
calculated.
}
\seealso{
\code{\link[=distanceSSLogN]{distanceSSLogN()}}, \code{\link[=distanceMaxRelRDI]{distanceMaxRelRDI()}}
}
