% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml_nnet.R
\name{mlNnet}
\alias{mlNnet}
\alias{ml_nnet}
\alias{mlNnet.formula}
\alias{mlNnet.default}
\alias{predict.mlNnet}
\title{Supervised classification and regression using neural network}
\usage{
mlNnet(train, ...)

ml_nnet(train, ...)

\method{mlNnet}{formula}(
  formula,
  data,
  size = NULL,
  rang = NULL,
  decay = 0,
  maxit = 1000,
  ...,
  subset,
  na.action
)

\method{mlNnet}{default}(train, response, size = NULL, rang = NULL, decay = 0, maxit = 1000, ...)

\method{predict}{mlNnet}(
  object,
  newdata,
  type = c("class", "membership", "both", "raw"),
  method = c("direct", "cv"),
  na.action = na.exclude,
  ...
)
}
\arguments{
\item{train}{a matrix or data frame with predictors.}

\item{...}{further arguments passed to \code{\link[nnet:nnet]{nnet::nnet()}} that has many more
parameters (see its help page).}

\item{formula}{a formula with left term being the factor variable to predict
(for supervised classification), a vector of numbers (for regression) and the
right term with the list of independent, predictive variables, separated with
a plus sign. If the data frame provided contains only the dependent and
independent variables, one can use the \code{class ~ .} short version (that one is
strongly encouraged). Variables with minus sign are eliminated. Calculations
on variables are possible according to usual formula convention (possibly
protected by using \code{I()}).}

\item{data}{a data.frame to use as a training set.}

\item{size}{number of units in the hidden layer. Can be zero if there are
skip-layer units. If \code{NULL} (the default), a reasonable value is computed.}

\item{rang}{initial random weights on [-rang, rang]. Value about 0.5 unless
the inputs are large, in which case it should be chosen so that
rang * max(|x|) is about 1. If \code{NULL}, a reasonable default is computed.}

\item{decay}{parameter for weight decay. Default to 0.}

\item{maxit}{maximum number of iterations. Default 1000 (it is 100 in
\code{\link[nnet:nnet]{nnet::nnet()}}).}

\item{subset}{index vector with the cases to define the training set in use
(this argument must be named, if provided).}

\item{na.action}{function to specify the action to be taken if \code{NA}s are
found. For \code{\link[=ml_nnet]{ml_nnet()}} \code{na.fail} is used by default. The calculation is
stopped if there is any \code{NA} in the data. Another option is \code{na.omit},
where cases with missing values on any required variable are dropped (this
argument must be named, if provided). For the \code{predict()} method, the
default, and most suitable option, is \code{na.exclude}. In that case, rows with
\code{NA}s in \verb{newdata=} are excluded from prediction, but reinjected in the
final results so that the number of items is still the same (and in the
same order as \verb{newdata=}).}

\item{response}{a vector of factor (classification) or numeric (regression).}

\item{object}{an \strong{mlNnet} object}

\item{newdata}{a new dataset with same conformation as the training set (same
variables, except may by the class for classification or dependent variable
for regression). Usually a test set, or a new dataset to be predicted.}

\item{type}{the type of prediction to return. \code{"class"} by default, the
predicted classes. Other options are \code{"membership"} the membership (number
between 0 and 1) to the different classes, or \code{"both"} to return classes
and memberships. Also type \code{"raw"} as non normalized result as returned by
\code{\link[nnet:nnet]{nnet::nnet()}} (useful for regression, see examples).}

\item{method}{\code{"direct"} (default) or \code{"cv"}. \code{"direct"} predicts new cases
in \verb{newdata=} if this argument is provided, or the cases in the training
set if not. Take care that not providing \verb{newdata=} means that you just
calculate the \strong{self-consistency} of the classifier but cannot use the
metrics derived from these results for the assessment of its performances.
Either use a different data set in \verb{newdata=} or use the alternate
cross-validation ("cv") technique. If you specify \code{method = "cv"} then
\code{\link[=cvpredict]{cvpredict()}} is used and you cannot provide \verb{newdata=} in that case.}
}
\value{
\code{\link[=ml_nnet]{ml_nnet()}}/\code{\link[=mlNnet]{mlNnet()}} creates an \strong{mlNnet}, \strong{mlearning} object
containing the classifier and a lot of additional metadata used by the
functions and methods you can apply to it like \code{\link[=predict]{predict()}} or
\code{\link[=cvpredict]{cvpredict()}}. In case you want to program new functions or extract
specific components, inspect the "unclassed" object using \code{\link[=unclass]{unclass()}}.
}
\description{
Unified (formula-based) interface version of the single-hidden-layer neural
network algorithm, possibly with skip-layer connections provided by
\code{\link[nnet:nnet]{nnet::nnet()}}.
}
\examples{
# Prepare data: split into training set (2/3) and test set (1/3)
data("iris", package = "datasets")
train <- c(1:34, 51:83, 101:133)
iris_train <- iris[train, ]
iris_test <- iris[-train, ]
# One case with missing data in train set, and another case in test set
iris_train[1, 1] <- NA
iris_test[25, 2] <- NA

set.seed(689) # Useful for reproductibility, use a different value each time!
iris_nnet <- ml_nnet(data = iris_train, Species ~ .)
summary(iris_nnet)
predict(iris_nnet) # Default type is class
predict(iris_nnet, type = "membership")
predict(iris_nnet, type = "both")
# Self-consistency, do not use for assessing classifier performances!
confusion(iris_nnet)
# Use an independent test set instead
confusion(predict(iris_nnet, newdata = iris_test), iris_test$Species)

# Idem, but two classes prediction
data("HouseVotes84", package = "mlbench")
set.seed(325)
house_nnet <- ml_nnet(data = HouseVotes84, Class ~ ., na.action = na.omit)
summary(house_nnet)
# Cross-validated confusion matrix
confusion(cvpredict(house_nnet), na.omit(HouseVotes84)$Class)

# Regression
data(airquality, package = "datasets")
set.seed(74)
ozone_nnet <- ml_nnet(data = airquality, Ozone ~ ., na.action = na.omit,
  skip = TRUE, decay = 1e-3, size = 20, linout = TRUE)
summary(ozone_nnet)
plot(na.omit(airquality)$Ozone, predict(ozone_nnet, type = "raw"))
abline(a = 0, b = 1)
}
\seealso{
\code{\link[=mlearning]{mlearning()}}, \code{\link[=cvpredict]{cvpredict()}}, \code{\link[=confusion]{confusion()}}, also \code{\link[nnet:nnet]{nnet::nnet()}}
that actually does the classification.
}
