% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlm_assumptions.R
\name{mlm_assumptions}
\alias{mlm_assumptions}
\title{Reports the output of testing all assumptions for a multilevel model}
\usage{
mlm_assumptions(model)
}
\arguments{
\item{model}{A linear mixed-effects model of class lmerMod, lmerModLmerTest, or glmerMod of type binomial.}
}
\value{
Tests the relevant assumptions of the specified multilevel model.
}
\description{
Reports the results from testing all assumptions of a multilevel model and provides suggestions if an assumption is not passed
}
\examples{
# Read in data
data(instruction)
# Create model
mod <- lme4::lmer(mathgain ~ mathkind + (1 | classid), data = instruction)
# Evaluate assumptions
mlm_assumptions(mod)

}
\references{
Glaser, R. E. (2006). Levene’s Robust Test of Homogeneity of Variances. Encyclopedia of Statistical Sciences. 6.
}
