% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varCompare.R
\name{varCompare}
\alias{varCompare}
\title{Compares variance explained for two mixed effects models}
\usage{
varCompare(model1, model2)
}
\arguments{
\item{model1}{A linear mixed-effects model of class lmerMod or lmerModLmerTest}

\item{model2}{A linear mixed-effects model of class lmerMod or lmerModLmerTest}
}
\value{
Computes the percent increase in variance explained by the less parsimonious (more complicated) model compared to the more parsimonious (less complicated) model.
}
\description{
Compares variance explained by additional fixed effects for two lme4-fitted mixed-effects models.
}
\details{
Specifically,  1-(total variance for less parsimonious model/total variance for more parsimonious model).
}
\examples{
# Read in data
data(instruction)
# Create null model
mod0 <- lme4::lmer(mathgain ~ (1 | classid), data = instruction)
# Create model of interest
mod1 <- lme4::lmer(mathgain ~ mathkind + (1 | classid), data = instruction)
# Compare variance explained
### To repress output: use invisible()
varCompare(mod0, mod1)

}
\references{
Snijders, T. A. B. & Bosker, R. J. (2012). Multilevel Analysis (2nd Ed.). Sage Publications Ltd.
}
