% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpEOd.R
\name{mlr_pipeops_equalized_odds}
\alias{mlr_pipeops_equalized_odds}
\alias{PipeOpEOd}
\title{Equalized Odds Debiasing}
\format{
\link[R6:R6Class]{R6::R6Class} object inheriting from
\link[mlr3pipelines:PipeOpTaskPreproc]{mlr3pipelines::PipeOpTaskPreproc}/
\link[mlr3pipelines:PipeOp]{mlr3pipelines::PipeOp}.
}
\description{
Fairness post-processing method to achieve equalized odds fairness.
Works by randomly flipping a subset of predictions with pre-computed
probabilities in order to satisfy equalized odds constraints.\cr
NOTE: Carefully assess the correct privileged group.
}
\section{Construction}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{PipeOpEOd*$new(id = "eod", param_vals = list())
}\if{html}{\out{</div>}}
\itemize{
\item \code{id} (\verb{character(1))}.
\item \code{param_vals} (\code{list()})
}
}

\section{Input and Output Channels}{

Input and output channels are inherited from \link[mlr3pipelines:PipeOpTaskPreproc]{mlr3pipelines::PipeOpTaskPreproc}. Instead of a \link[mlr3:Task]{mlr3::Task}, a
\link[mlr3:TaskClassif]{mlr3::TaskClassif} is used as input and output during training and prediction.

The output during training is the input \link[mlr3:Task]{mlr3::Task}. The output during prediction is
a \link[mlr3:PredictionClassif]{mlr3::PredictionClassif} with partially flipped predictions.
}

\section{State}{

The \verb{$state} is a named list with the \verb{$state} elements inherited from \link[mlr3pipelines:PipeOpTaskPreproc]{mlr3pipelines::PipeOpTaskPreproc}.
}

\section{Parameters}{

\itemize{
\item \code{alpha} (numeric): A number between 0 (no debiasing) and 1 (full debiasing).
Controls the debiasing strength by multiplying the flipping probabilities with alpha.
\item \code{privileged} (character): The privileged group.
}
}

\section{Fields}{

Only fields inherited from \link[mlr3pipelines:PipeOpTaskPreproc]{mlr3pipelines::PipeOpTaskPreproc}/\link[mlr3pipelines:PipeOp]{mlr3pipelines::PipeOp}.
}

\section{Methods}{

Methods inherited from \link[mlr3pipelines:PipeOpTaskPreproc]{mlr3pipelines::PipeOpTaskPreproc}/\link[mlr3pipelines:PipeOp]{mlr3pipelines::PipeOp}.
}

\examples{
\dontshow{if (rlang::is_installed("rpart")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library("mlr3")
library("mlr3pipelines")

eod = po("EOd")
learner_po = po("learner_cv",
  learner = lrn("classif.rpart"),
  resampling.method = "insample"
)

task = tsk("compas")
graph = learner_po \%>>\% eod
glrn = GraphLearner$new(graph)
glrn$train(task)

# On a Task
glrn$predict(task)

# On newdata
glrn$predict_newdata(task$data(cols = task$feature_names))
\dontshow{\}) # examplesIf}
}
\references{
Hardt M, Price E, Srebro N (2016).
\dQuote{Equality of Opportunity in Supervised Learning.}
In \emph{Advances in Neural Information Processing Systems}, volume 29, 3315--3323.
\url{https://papers.nips.cc/paper/2016/file/9d2682367c3935defcb1f9e247a97c0d-Paper.pdf}.

Pleiss, Geoff, Raghavan, Manish, Wu, Felix, Kleinberg, Jon, Weinberger, Q K (2017).
\dQuote{On Fairness and Calibration.}
In Guyon I, Luxburg UV, Bengio S, Wallach H, Fergus R, Vishwanathan S, Garnett R (eds.), \emph{Advances in Neural Information Processing Systems}, volume 30.
\url{https://proceedings.neurips.cc/paper/2017/file/b8b9c74ac526fffbeb2d39ab038d1cd7-Paper.pdf}.
}
\seealso{
https://mlr3book.mlr-org.com/list-pipeops.html

Other PipeOps: 
\code{\link{mlr_pipeops_explicit_pta}},
\code{\link{mlr_pipeops_reweighing}}
}
\concept{PipeOps}
\section{Super class}{
\code{\link[mlr3pipelines:PipeOp]{mlr3pipelines::PipeOp}} -> \code{PipeOpEOd}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PipeOpEOd-new}{\code{PipeOpEOd$new()}}
\item \href{#method-PipeOpEOd-clone}{\code{PipeOpEOd$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="help"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-help'><code>mlr3pipelines::PipeOp$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="predict"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-predict'><code>mlr3pipelines::PipeOp$predict()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="print"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-print'><code>mlr3pipelines::PipeOp$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="train"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-train'><code>mlr3pipelines::PipeOp$train()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipeOpEOd-new"></a>}}
\if{latex}{\out{\hypertarget{method-PipeOpEOd-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[mlr3pipelines:PipeOp]{R6::R6Class} R6 class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpEOd$new(id = "EOd", param_vals = list())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{character \cr
The PipeOps identifier in the PipeOps library.}

\item{\code{param_vals}}{list \cr
The parameter values to be set. See \code{Parameters}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipeOpEOd-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PipeOpEOd-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpEOd$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
