% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CallbackBatchFSelect.R
\name{callback_batch_fselect}
\alias{callback_batch_fselect}
\title{Create Feature Selection Callback}
\usage{
callback_batch_fselect(
  id,
  label = NA_character_,
  man = NA_character_,
  on_optimization_begin = NULL,
  on_optimizer_before_eval = NULL,
  on_eval_after_design = NULL,
  on_eval_after_benchmark = NULL,
  on_eval_before_archive = NULL,
  on_optimizer_after_eval = NULL,
  on_result = NULL,
  on_optimization_end = NULL,
  on_auto_fselector_before_final_model = NULL,
  on_auto_fselector_after_final_model = NULL
)
}
\arguments{
\item{id}{(\code{character(1)})\cr
Identifier for the new instance.}

\item{label}{(\code{character(1)})\cr
Label for the new instance.}

\item{man}{(\code{character(1)})\cr
String in the format \verb{[pkg]::[topic]} pointing to a manual page for this object.
The referenced help package can be opened via method \verb{$help()}.}

\item{on_optimization_begin}{(\verb{function()})\cr
Stage called at the beginning of the optimization.
Called in \code{Optimizer$optimize()}.}

\item{on_optimizer_before_eval}{(\verb{function()})\cr
Stage called after the optimizer proposes points.
Called in \code{OptimInstance$eval_batch()}.}

\item{on_eval_after_design}{(\verb{function()})\cr
Stage called after design is created.
Called in \code{ObjectiveFSelectBatch$eval_many()}.}

\item{on_eval_after_benchmark}{(\verb{function()})\cr
Stage called after feature sets are evaluated.
Called in \code{ObjectiveFSelectBatch$eval_many()}.}

\item{on_eval_before_archive}{(\verb{function()})\cr
Stage called before performance values are written to the archive.
Called in \code{ObjectiveFSelectBatch$eval_many()}.}

\item{on_optimizer_after_eval}{(\verb{function()})\cr
Stage called after points are evaluated.
Called in \code{OptimInstance$eval_batch()}.}

\item{on_result}{(\verb{function()})\cr
Stage called after result are written.
Called in \code{OptimInstance$assign_result()}.}

\item{on_optimization_end}{(\verb{function()})\cr
Stage called at the end of the optimization.
Called in \code{Optimizer$optimize()}.}

\item{on_auto_fselector_before_final_model}{(\verb{function()})\cr
Stage called before the final model is trained.
Called in \code{AutoFSelector$train()}.}

\item{on_auto_fselector_after_final_model}{(\verb{function()})\cr
Stage called after the final model is trained.
Called in \code{AutoFSelector$train()}.}
}
\description{
Function to create a \link{CallbackBatchFSelect}.
Predefined callbacks are stored in the \link[mlr3misc:Dictionary]{dictionary} \link{mlr_callbacks} and can be retrieved with \code{\link[=clbk]{clbk()}}.

Feature selection callbacks can be called from different stages of feature selection.
The stages are prefixed with \verb{on_*}.
The \verb{on_auto_fselector_*} stages are only available when the callback is used in an \link{AutoFSelector}.

\if{html}{\out{<div class="sourceCode">}}\preformatted{Start Automatic Feature Selection
  Start Feature Selection
      - on_optimization_begin
      Start FSelect Batch
          - on_optimizer_before_eval
          Start Evaluation
              - on_eval_after_design
              - on_eval_after_benchmark
              - on_eval_before_archive
          End Evaluation
          - on_optimizer_after_eval
      End FSelect Batch
      - on_result
      - on_optimization_end
  End Feature Selection
  - on_auto_fselector_before_final_model
  - on_auto_fselector_after_final_model
End Automatic Feature Selection
}\if{html}{\out{</div>}}

See also the section on parameters for more information on the stages.
A feature selection callback works with \link[bbotk:ContextBatch]{bbotk::ContextBatch} and \link{ContextBatchFSelect}.
}
\details{
When implementing a callback, each function must have two arguments named \code{callback} and \code{context}.
A callback can write data to the state (\verb{$state}), e.g. settings that affect the callback itself.
Avoid writing large data the state.
}
\examples{
# Write archive to disk
callback_batch_fselect("mlr3fselect.backup",
  on_optimization_end = function(callback, context) {
    saveRDS(context$instance$archive, "archive.rds")
  }
)
}
