% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mf_list_variables.R
\name{mf_list_variables}
\alias{mf_list_variables}
\title{Get information for the variables (bands) available for a given collection}
\usage{
mf_list_variables(collection, credentials = NULL, verbose = "inform")
}
\arguments{
\item{collection}{string. mandatory. Collection of interest (see details of \link{mf_get_url}).}

\item{credentials}{vector string of length 2 with username and password. optional if the function \link{mf_login} was previously executed.}

\item{verbose}{string. Verbose mode ("quiet", "inform", or "debug"). Default "inform".}
}
\value{
A data.frame with the variables available for the collection, and a set of related information for each variable.
The variables marked as "extractable" in the column "extractable_with_modisfast" can be provided as input parameter \code{variables} of the function \link{mf_get_url}
}
\description{
Get the variables available for a given collection, along with a set of related information for each.
}
\examples{
\dontrun{
# login to Earthdata
log <- mf_login(c("earthdata_un", "earthdata_pw"))

# Get the variables available for the collection MOD11A1.061
(df_varinfo <- mf_list_variables("MOD11A1.061"))
}

}
