% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_main.R
\name{movedesign_input}
\alias{movedesign_input}
\title{Create a \code{movedesign_input} object for simulation workflows}
\usage{
movedesign_input(design)
}
\arguments{
\item{design}{A named list containing user-specified inputs for
a \code{movedesign} workflow. At a minimum, this includes elements
such as \code{data}, \code{dur}, \code{dti}, \code{n_individuals}, and \code{set_target}.}
}
\value{
An object of class \code{movedesign_input} and \code{movedesign},
which contains all input parameters and metadata required
for a \code{movedesign} workflow.
}
\description{
Constructs an S3 object of class \code{movedesign_input}, encapsulating
all parameters and metadata required for a simulation-based
study design. This object includes elements such as number of
individuals (\emph{population} sample size), study duration, sampling
interval, movement models, grouping structure (if specified), and
estimation targets. The standardized \code{movedesign_input} object is
the expected input for downstream \code{movedesign} functions.

Use \code{\link[=md_prepare]{md_prepare()}} to construct a complete study design input
object, which can then be passed to functions like
\code{\link[=md_run]{md_run()}} and \code{\link[=md_replicate]{md_replicate()}}.
}
\seealso{
\code{\link[=md_prepare]{md_prepare()}}
}
\keyword{internal}
