% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mppData_add_pheno.R
\name{mppData_add_pheno}
\alias{mppData_add_pheno}
\title{Add new phenotypic values to a mppData object}
\usage{
mppData_add_pheno(mppData, pheno)
}
\arguments{
\item{mppData}{An object of class \code{mppData}.}

\item{pheno}{\code{data.frame} with : 1) \code{character}
genotypes identifiers; 2) \code{numeric} trait values. \strong{The genotypes
identifiers must be identical to \code{mppData$geno.id}.}}
}
\value{
Return:

\item{mppData}{New \code{mppData} object with new phenotypic values added.}
}
\description{
Add the new phenotypic values contained in 'pheno' to a \code{mppData} object.
}
\examples{

data(mppData)
pheno_new <- data.frame(geno.id = mppData$geno.id, ph1 = rnorm(498))

mppData <- mppData_add_pheno(mppData = mppData, pheno = pheno_new)

}
\seealso{
\code{\link{mppData_mdf_pheno}}, \code{\link{subset.mppData}},
}
\author{
Vincent Garin
}
