% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_Upset.R
\name{plot_Upset}
\alias{plot_Upset}
\title{Upset Plot}
\usage{
plot_Upset(
  input_list,
  label = c("Precursor.IDs", "Peptide.IDs", "Protein.IDs", "ProteinGroup.IDs"),
  nr_intersections = 10,
  highlight_overlap = FALSE
)
}
\arguments{
\item{input_list}{A list with data frames and respective level information.}

\item{label}{Character string. Choose between "Precursor.IDs", "Peptide.IDs", "Protein.IDs" or "ProteinGroup.IDs" for corresponding level. Default is "Precursor.IDs".}

\item{nr_intersections}{Numeric. Maximum number of intersections shown in plot. Default is 10.}

\item{highlight_overlap}{Logical. If TRUE, overlapping intersections is highlighted in yellow. Default is FALSE. If TRUE, overlapping intersections need to be in plot!}
}
\value{
This function returns a Upset plot.
}
\description{
Plot intersections of analyses for different levels.
}
\details{
Identifications per level of each analysis are compared and possible intersections visualized.
}
\examples{
# Load libraries
library(UpSetR)
library(tibble)

# Example data
data <- list(
 "A" = c("A", "B", "C", "D"),
 "B" = c("A", "B", "C", "F"),
 "C" = c("A", "B", "G", "E")
)

# Plot
plot_Upset(
  input_list = data,
  label = "Peptide.IDs"
)
}
\author{
Oliver Kardell
}
