% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsa.R
\name{lsa}
\alias{lsa}
\alias{lsa_plot}
\title{Perform local sensitivity analysis}
\usage{
lsa(mod, par, var, fun = .lsa_fun, eps = 1e-07, ...)

lsa_plot(x, ...)
}
\arguments{
\item{mod}{a mrgsolve model object.}

\item{par}{parameter names as character vector or comma-separated string.}

\item{var}{output names (compartment or capture) as character vector
or comma-separated string.}

\item{fun}{generating simulated for sensitivity analysis (see details).}

\item{eps}{parameter change value for sensitivity analysis.}

\item{...}{passed to \code{\link[=plot.lsa]{plot.lsa()}}.}

\item{x}{output from \code{lsa()}.}
}
\value{
A tibble with class \code{lsa}.
}
\description{
Perform local sensitivity analysis
}
\examples{
mod <- mrgsolve::house(delta=0.1)

par <- "CL,VC,KA"

var <- "CP"

dose <- ev(amt = 100)

fun <- function(mod, ...) mrgsolve::mrgsim_e(mod, dose, output="df")

out <- lsa(mod, par, var, fun)

head(out)

lsa_plot(out)

}
