% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slice.R
\name{ggslice}
\alias{ggslice}
\title{Generate an axis-parallel slice display}
\usage{
ggslice(data, h, v1 = 1, v2 = 2, center = NULL, col = NULL)
}
\arguments{
\item{data}{data frame containing only variables used for the display}

\item{h}{slice thickness}

\item{v1}{column number of variable mapped to x-axis}

\item{v2}{column number of variable mapped to y-axis}

\item{center}{center point vector used for anchoring the slice,
if NULL the mean of the data is used}

\item{col}{grouping vector mapped to color in the display}
}
\value{
ggplot2 object showing the sliced data
}
\description{
Following the slice definition available in \code{tourr}
this function returns a \code{ggplot2} display of a slice
defined via the projection onto two of the variables.
Note that because the underlying function works with any
projection, the axis labels need to be set by the user.
}
\examples{
d <- geozoo::sphere.hollow(4, 1000)$points
ggslice(d, 0.3, 1, 2)
ggslice(d, 0.3, 1, 2, center = c(0, 0, 0.7, 0))
}
\seealso{
ggslice_projection
}
