% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unsupervised.R
\name{sca}
\alias{sca}
\title{Simultaneous Component Analysis - SCA}
\usage{
sca(X, ncomp = 2, scale = FALSE, samplelinked = "auto", ...)
}
\arguments{
\item{X}{\code{list} of input blocks.}

\item{ncomp}{\code{integer} number of components to extract.}

\item{scale}{\code{logical} indicating autoscaling of features (default = FALSE).}

\item{samplelinked}{\code{character/logical} indicating if blocks are linked by samples (TRUE) or variables (FALSE). Using 'auto' (default), this will be determined automatically.}

\item{...}{additional arguments (not used).}
}
\value{
\code{multiblock} object including relevant scores and loadings. Relevant plotting functions: \code{\link{multiblock_plots}}
and result functions: \code{\link{multiblock_results}}.
}
\description{
This is a basic implementation of the SCA-P algorithm (least restricted SCA) with support for both
sample- and variable-linked modes.
}
\details{
SCA, in its original variable-linked version, calculates common loadings and block-wise
scores. There are many possible constraints and specialisations. This implementations uses
PCA as the backbone, thus resulting in deterministic, ordered components. A parameter controls
the linking mode, but if left untouched an attempt is made at automatically determining
variable or sample linking.
}
\examples{
# Object linked data
data(potato)
potList <- as.list(potato[c(1,2,9)])
pot.sca    <- sca(potList)
plot(scores(pot.sca), labels="names")

# Variable linked data
data(candies)
candyList <- lapply(1:nlevels(candies$candy),function(x)candies$assessment[candies$candy==x,])
pot.sca    <- sca(candyList, samplelinked = FALSE)
pot.sca

}
\references{
Levin, J. (1966) Simultaneous factor analysis of several gramian matrices. Psychometrika, 31(3), 413–419.
}
\seealso{
Overviews of available methods, \code{\link{multiblock}}, and methods organised by main structure: \code{\link{basic}}, \code{\link{unsupervised}}, \code{\link{asca}}, \code{\link{supervised}} and \code{\link{complex}}.
Common functions for computation and extraction of results and plotting are found in \code{\link{multiblock_results}} and \code{\link{multiblock_plots}}, respectively.
}
