% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multivarObjectClass.R
\docType{methods}
\name{cv.multivar}
\alias{cv.multivar}
\alias{cv.multivar,multivar-method}
\title{Cross Validation for multivar}
\usage{
cv.multivar(object)
}
\arguments{
\item{object}{multivar object built using \code{ConstructModel}.}
}
\value{
An object of class \code{multivar.results}.
}
\description{
Cross Validation for multivar
}
\details{
The main function of the multivar package. Performs cross validation to select penalty parameters over a training sample and evaluates them over a test set.
}
\examples{

# example 1 (run)
sim1  <- multivar_sim(
  k = 2,  # individuals
  d = 5,  # number of variables
  n = 20, # number of timepoints
  prop_fill_com = 0.1, # proportion of paths common
  prop_fill_ind = 0.05, # proportion of paths unique
  lb = 0.1,  # lower bound on coefficient magnitude
  ub = 0.5,  # upper bound on coefficient magnitude
  sigma = diag(5) # noise
)

model1 <- constructModel(data = sim1$data)
fit1 <- multivar::cv.multivar(model1)


}
