% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s03_all_functions.R
\name{addWeak}
\alias{addWeak}
\title{Add Weak Mutation TYpes}
\usage{
addWeak(
  mutationTypesToAddSet,
  processes_I,
  processesStd_I,
  Wall_I,
  genomeErrors_I,
  genomesReconstructed_I
)
}
\arguments{
\item{mutationTypesToAddSet}{Set of mutations to restore}

\item{processes_I}{Set of Mutational Processes}

\item{processesStd_I}{Set of standard deviations of all Mutational Processes}

\item{Wall_I}{Set of all W matrices previously extracted}

\item{genomeErrors_I}{Set of all residuals}

\item{genomesReconstructed_I}{Fitted Values according to the most likely Model}
}
\value{
Output is the final result of the deconvolution process
}
\description{
Restore Mutation Types that were initially excluded because a low number of total counts.
}
\details{
This is one of the core functions included in the original mutSignatures R library, 
and in the WTSI MATLAB framework. This is an internal function.
}
\references{
More information and examples about mutational signature analysis can be found here:
\enumerate{
  \item \bold{GitHub Repo}: \url{https://github.com/dami82/mutSignatures/}
  \item \bold{More info and examples} about the mutSignatures R library: \url{https://www.data-pulse.com/dev_site/mutsignatures/}
  \item \bold{Sci Rep paper}, introducing mutS: \url{https://www.nature.com/articles/s41598-020-75062-0/}
  \item \bold{Oncogene paper}, Mutational Signatures Operative in Bladder Cancer: \url{https://www.nature.com/articles/s41388-017-0099-6}
  \item WTSI framework: \url{https://www.ncbi.nlm.nih.gov/pmc/articles/PMC3588146/}
 }
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
\keyword{internal}
