% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutation_types.R
\name{select_most_severe_consequence_pave}
\alias{select_most_severe_consequence_pave}
\title{Select the most severe consequence (PAVE)}
\usage{
select_most_severe_consequence_pave(
  pave_mutation_types,
  missing_is_valid = FALSE
)
}
\arguments{
\item{pave_mutation_types}{a character vector of PAVE terms, where multiple pave_mutation_types per field are & delimited, and you want to choose the most severe consequence .}

\item{missing_is_valid}{should NA values be considered valid mutation classes or should they throw an error? (flag)}
}
\value{
the most severe consequence for each element in pave_mutation_types
}
\description{
Take a character vector which may contain multiple PAVE mutation types separated by '&'
And choose only the most severe consequence
}
\examples{
select_most_severe_consequence_pave(
 c(
   "upstream_gene_variant&phased_synonymous&5_prime_UTR_variant",
   "missense_variant&frameshift_variant"
 )
)
#> Result:
#> c("phased_synonymous", "frameshift_variant")
}
