% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_reduce_umap.R
\name{run_reduce_umap}
\alias{run_reduce_umap}
\title{Run UMAP dimension reduction algorithm on an \code{mx_dataset} object.}
\usage{
run_reduce_umap(
  mx_data,
  table,
  marker_list,
  downsample_pct = 1,
  metadata_cols = NULL
)
}
\arguments{
\item{mx_data}{\code{mx_dataset} object used to compute UMAP dimensions}

\item{table}{dataset in \code{mx_data} used to compute metrics. Options include: c("raw","normalized","both"), e.g. a y-axis parameter.}

\item{marker_list}{list of markers in the \code{mx_dataset} object to use for UMAP algorithm}

\item{downsample_pct}{double, optional percentage (0, 1] of sample rows to include when running UMAP algorithm. (default=1)}

\item{metadata_cols}{other identifiers of the input \code{data} (default=NULL). This must be a vector of column name(s) in the \code{mx_dataset} object}
}
\value{
\code{mx_dataset} object with analysis results of UMAP dimension results in \code{umap_data} table
}
\description{
Run UMAP dimension reduction algorithm on an \code{mx_dataset} object.
}
\examples{
mx_data = mx_dataset(mxnorm::mx_sample, "slide_id", "image_id",
  c("marker1_vals","marker2_vals","marker3_vals"),
  c("metadata1_vals"))
mx_data = mx_normalize(mx_data, transform="log10",method="None")
mx_data = run_reduce_umap(mx_data, table="normalized",
c("marker1_vals","marker2_vals","marker3_vals"))
}
