% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cast-shadows.R
\name{cast_shadow_shift_label}
\alias{cast_shadow_shift_label}
\title{Add a shadow column and a shadow shifted column to a dataset}
\usage{
cast_shadow_shift_label(data, ...)
}
\arguments{
\item{data}{data.frame}

\item{...}{One or more unquoted expressions separated by commas. These also
respect the dplyr verbs "starts_with", "contains", "ends_with", etc.}
}
\value{
data.frame with the shadow and shadow_shift vars, and missing labels
}
\description{
Shift the values, add shadow, add missing label
}
\examples{

airquality \%>\% cast_shadow_shift_label(Ozone, Solar.R)

# replicate the plot generated by geom_miss_point()
\dontrun{
library(ggplot2)

airquality \%>\%
  cast_shadow_shift_label(Ozone,Solar.R) \%>\%
  ggplot(aes(x = Ozone_shift,
             y = Solar.R_shift,
             colour = any_missing)) +
        geom_point()
}

}
\seealso{
\code{\link[=cast_shadow_shift]{cast_shadow_shift()}}, \code{\link[=cast_shadow_shift_label]{cast_shadow_shift_label()}} \code{\link[=bind_shadow]{bind_shadow()}} \code{\link[=add_any_miss]{add_any_miss()}} \code{\link[=add_label_missings]{add_label_missings()}} \code{\link[=add_label_shadow]{add_label_shadow()}} \code{\link[=add_miss_cluster]{add_miss_cluster()}} \code{\link[=add_prop_miss]{add_prop_miss()}} \code{\link[=add_shadow_shift]{add_shadow_shift()}}
}
