% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nanotime.R
\name{seq.nanotime}
\alias{seq.nanotime}
\alias{seq,nanotime-method}
\title{Sequence Generation}
\usage{
\method{seq}{nanotime}(from, to = NULL, by = NULL, length.out = NULL, along.with = NULL, ...)

\S4method{seq}{nanotime}(from, to = NULL, by = NULL, length.out = NULL, along.with = NULL, ...)
}
\arguments{
\item{from, to}{the starting and (maximal) end values of the
sequence}

\item{by}{\code{nanoduration} or \code{nanoperiod} increment of
the sequence; note that if the class is \code{nanoperiod} the
additional argument \code{tz} must be speficied and is of
\code{character} type indicating a timezone}

\item{length.out}{integer indicating the desired length of the sequence}

\item{along.with}{take the length from the length of this argument.}

\item{...}{arguments passed to or from methods; the only
interesting additional argument is \code{tz} where the
\code{to} argument is of type \code{nanoperiod}}
}
\description{
Generate a sequence of \code{nanotime}
}
\examples{
\dontrun{
from <- as.nanotime("2018-01-14T12:44:00+00:00")
to   <- as.nanotime("2019-01-14T12:44:00+00:00")
seq(from, to, by=as.nanoperiod("1m"), tz="America/New_York")
seq(from, by=as.nanoperiod("1y"), length.out=4, tz="Europe/London")
}
}
