% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auto_narfima.R
\name{auto_narfima}
\alias{auto_narfima}
\title{Fitting a NARFIMA Model}
\usage{
auto_narfima(
  y,
  er,
  xreg = NULL,
  p,
  q,
  P = 1,
  size,
  skip,
  repeats = 1000,
  lambda = 0.5,
  lambdae = 0.5,
  scale.inputs = TRUE,
  ...
)
}
\arguments{
\item{y}{A numeric vector or time series of class \code{ts}.}

\item{er}{A numeric vector or time series object representing the series of residuals. If missing, it will be calculated from an ARFIMA model with exogenous variable (if provided).}

\item{xreg}{An optional numeric matrix of exogenous variables to be included in the model (default is \code{NULL}).}

\item{p}{Integer indicating the number of lags of the input series \code{y}.}

\item{q}{Integer indicating the number of lags of the errors \code{er}.}

\item{P}{Integer indicating the number of seasonal lags of the input series \code{y} (default is \code{1}).}

\item{size}{Integer specifying the number of nodes of the feed-forward neural networks with a single hidden layer.}

\item{skip}{Logical value indicating whether to use the direct connections in the neural network (default is \code{TRUE}).}

\item{repeats}{Integer specifying the number of times to fit the neural network model (default is \code{1000}).}

\item{lambda}{Numeric value for the Box-Cox transformation parameter of \code{y} (default is \code{0.5}).}

\item{lambdae}{Numeric value for the Box-Cox transformation parameter of \code{er} (default is \code{0.5}).}

\item{scale.inputs}{Logical value indicating whether to standardize the inputs before fitting the model (default is \code{TRUE}).}

\item{...}{Additional arguments passed to \code{auto_narfima}.}
}
\value{
Returns an object of class "narfima", containing the following components:
\item{series}{The name of the input series.}
\item{method}{A string describing the model parameters.}
\item{model}{The fitted NARFIMA model.}
\item{fitted}{The fitted values from the model.}
\item{residuals}{The residuals from the model.}
\item{m}{The seasonal frequency of the input series.}
\item{p}{The number of Autoregressive terms used.}
\item{q}{The number of moving average terms used.}
\item{P}{The number of seasonal lags used.}
\item{size}{The number of nodes in the hidden layer used in the neural network.}
\item{skip}{Indicates if the direct connections were used in the neural network.}
\item{lambda}{The Box-Cox transformation parameter for the input series.}
\item{scaley}{Scaling parameters for the input series.}
\item{lags}{The lags used for the input series.}
\item{lambdae}{The Box-Cox transformation parameter for the error term.}
\item{scalee}{Scaling parameters for the error term.}
\item{lagse}{The lags used for the error term.}
\item{scalexreg}{Scaling parameters for the exogenous variables, if provided.}
\item{y}{The input time series.}
\item{e}{The transformed residual series}
\item{xreg}{The exogenous variables used in the model, if provided.}
\item{nnetargs}{Additional arguments passed to the neural network function.}
}
\description{
This function fits a Neural AutoRegressive Fractionally Integrated Moving Average (NARFIMA) model to univariate time series. The model uses \code{p} Autoregressive terms, \code{q} moving average
terms, and a single hidden layer with \code{size} nodes. If \code{p}, \code{q}, or \code{size} are not specified, they are automatically
determined:
\itemize{
\item \code{p} is set to the number of significant Autoregressive coefficients estimated from an AR model.
\item \code{q} is set to the order of the moving average component from an ARFIMA model fitted to the residuals.
\item \code{size} is set to the floor of half the sum of \code{p} and \code{q}: \deqn{size = \lfloor\frac{p + q}{2}\rfloor.}}
Exogenous variables can be included via \code{xreg}. If \code{er} is not
provided, it is computed from an ARFIMA model fitted to \code{y}. When \code{y} or \code{xreg} have missing values, the corresponding
rows and any dependent lagged rows are removed before fitting the model. Multiple neural network models are fitted, each initialized
with random weights, and the final model is obtained by averaging their outputs. Optionally, Box-Cox transformations can be applied
to stabilize variance, and inputs can be scaled to improve model convergence.
}
\examples{
h <- 3

data <- EuStockMarkets[(nrow(EuStockMarkets) - 53):nrow(EuStockMarkets),4]

train <- data[1:(length(data) - h)]
test <- data[(length(data) - h + 1):length(data)]

narfima_model <- auto_narfima(train)

}
