% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flux_fingerprint_plot.R
\name{flux_fingerprint_plot}
\alias{flux_fingerprint_plot}
\title{Helper function to plot QF results for fluxes.}
\usage{
flux_fingerprint_plot(input_fluxes, input_diffus_method = "Marshall")
}
\arguments{
\item{input_fluxes}{data frame of computed fluxes}

\item{input_diffus_method}{character string of diffusivity method used to compute fluxes. Can be one of "Marshall" or "Millington-Quirk".}
}
\value{
A ggplot graph where we have ordered factors showing the QA values a given flux computation
}
\description{
Given a flux measurement data frame, show when the flux and diffusivity measurements produced a QF value
}
\examples{
# Make a fingerprint plot for computed flux values:
flux_fingerprint_plot(sjer_flux_2022_06)
}
\author{
John Zobitz \email{zobitz@augsburg.edu}
}
