% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_DD.R
\name{make_DD}
\alias{make_DD}
\title{Makes a Duplication and Divergence Network}
\usage{
make_DD(size, net_kind, divergence, directed = TRUE)
}
\arguments{
\item{size}{Number of nodes in the network.}

\item{net_kind}{If the network is an adjacency matrix ("matrix") or an edge list ("list").}

\item{divergence}{Probability that the new node loses edges associated with the node it duplicates. Needs to be between zero and one.}

\item{directed}{Whether the target network is directed. Defaults to TRUE.}
}
\value{
An adjacency matrix.
}
\description{
Makes a network according to the Duplication and Divergence mechanism.
}
\details{
Different from Duplication & Mutation models in that edges can only be lost.
}
\examples{
# Import netcom
library(netcom)

# Network size (number of nodes)
size <- 10

# Divergence parameter
divergence <- 0.237

# Make network according to the Duplication & Divergence mechanism
make_DD(size = size, net_kind = "matrix", divergence = divergence)

}
\references{
Ispolatov, I., Krapivsky, P. L., & Yuryev, A. (2005). Duplication-divergence model of protein interaction network. Physical review E, 71(6), 061911.
}
