% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlive.splines.R
\name{nlive.splines}
\alias{nlive.splines}
\title{Automated Estimation of the Linear Mixed Model with Splines}
\usage{
nlive.splines(
  dataset,
  ID,
  time,
  formula,
  random,
  splines = NULL,
  knots = NULL,
  Boundary.knots = NULL,
  traj.marg = FALSE
)
}
\arguments{
\item{dataset}{data frame containing the variables ID, time, outcome, and predictors (if any).}

\item{ID}{name of the variable representing the grouping structure specified with " (e.g., "ID" representing the unique identifier of participants).}

\item{time}{name of the variable representing the timescale specified with " (e.g., "time"), which can be negative or positive.}

\item{formula}{two-sided linear formula object for the fixed-effects in the linear mixed model. The response outcome is on the left of ~ and the covariates are separated by + on the right of ~. By default, an intercept is included. If no intercept, -1 should be the first term included on the right of ~.}

\item{random}{optional one-sided formula for the random-effects in the linear mixed model. Covariates with a random-effect are separated by +. Default is an intercept. If no intercept, -1 should be the first term included.}

\item{splines}{optional "ns" for Natural Cubic Splines. "bs" for Cubic B-splines. Default is "ns".}

\item{knots}{optional inner knots that define the spline basis. Typical values are the mean or median for one knot, quantiles for more knots. Default is two equally spaced inner knots (i.e., 33th, 66th percentiles).}

\item{Boundary.knots}{optional boundary points at which to impose the natural boundary conditions and anchor the spline basis. Default to the range of the data.}

\item{traj.marg}{optional logical indicating if the marginal estimated trajectory should be plotted for the most common profile of covariates, if any. Default to FALSE.

#' @return An object of from the existing \emph{lcmm} R package containing the results of the fit of the data
by a linear mixed model and with the function of time approximated using splines.}
}
\description{
The nlive.splines function allows to fit a Linear Mixed Models with the function of time approximated
with natural cubic splines or B-splines in the context of longitudinal Gaussian outcomes.
This function was designed to be intuitive enough to the less sophisticated users, while using
the existing hlme() function from the lcmm R package as well as the existing ns() and bs() functions from the
splines R package.
}
\details{
CAUTIONS REGARDING THE USE OF THE FUNCTION

traj.marg: if "TRUE", this argument automatically plots the estimated marginal trajectories of the longitudinal outcome
for the most common profile of covariates, if any (i.e., ref "1" for binary variables and mean values for continuous variables).
Thus, users must ensure that continuous variables are centered on the mean.
}
\examples{

#### Fitting a linear mixed model considering natural cubic splines
#### with 2 inner knots placed at the 33th and 66th percentile
\dontrun{
head(dataCog)
lmm.ns.fit = nlive.splines(dataCog, ID="ID", outcome="cognition", time="time")
}
#### plot(lmm.ns.fit): diagnostic plots - goodness-of-fit of lmm.ns.fit


}
\references{
Proust-Lima, C., Philipps, V., & Liquet, B. (2017). Estimation of Extended Mixed Models Using Latent Classes and Latent Processes: The R Package lcmm. Journal of Statistical Software, 78(2), 1–56. https://doi.org/10.18637/jss.v078.i02
Perperoglou, A., Sauerbrei, W., Abrahamowicz, M. et al. A review of spline function procedures in R. BMC Med Res Methodol 19, 46 (2019). https://doi.org/10.1186/s12874-019-0666-3
}
\author{
Maude Wagner, Ana W. Capuano, Cecile Proust-lima

\email{maude_wagner@rush.edu}
}
