% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cast_matrix_to_numeric.R
\name{cast_matrix_to_numeric}
\alias{cast_matrix_to_numeric}
\title{Cast a matrix of any type to numeric}
\usage{
cast_matrix_to_numeric(expression.matrix)
}
\arguments{
\item{expression.matrix}{The expression matrix (usually read from a file)}
}
\value{
The expression matrix transformed to numeric, preserving row and column names.
Any values that are not coercible to numeric are replaced by 0.
}
\description{
Transforms values in the expression matrix to numeric,
to make it compatible with the rest of the functions.
}
\examples{
cast_matrix_to_numeric(matrix(
    c(1, "2", 3.0, 4),
    ncol=2,
    dimnames=list(paste0("X", 1:2),
                  paste0("Y", 1:2))))
}
