% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/npd_data_sim.R
\name{npd_data_sim}
\alias{npd_data_sim}
\title{Simulate the demand and attributes for new products}
\usage{
npd_data_sim(
  products_number,
  periods_number,
  shape_number,
  shape_type = "random",
  level_number,
  level_range = 1000:10000,
  noise_cv = 0.05,
  attribute_type = "ind",
  attributes_number = 10,
  shape_attributes_number = 5,
  level_attributes_number = 3
)
}
\arguments{
\item{products_number}{Number of products}

\item{periods_number}{Number of periods of the introduction and growth phases}

\item{shape_number}{Number of generic shapes}

\item{shape_type}{Type of shape to generate. It can take the values: "triangle",
"trapezoid", "bass", "random" and "intro & growth".
  The type "random" picks one of the types "triangle",
"trapezoid", "bass" randomly for each product.
The type "intro & growth" is used for the shapes of the introduction
and growth phases.}

\item{level_number}{Number of generic levels}

\item{level_range}{Range of values from which the level is sampled}

\item{noise_cv}{The coefficient of variation of the noise added to the simulated sales}

\item{attribute_type}{Type of relationship between attributes and shape and level.
There can be independent attributes or dependent attributes. attribute_type takes
one of the two values: "dep" and "ind". Check `attribute_sim_dep` and `attribute_sim_dep`.}

\item{attributes_number}{The number of attributes}

\item{shape_attributes_number}{The number of attributes assigned to shape}

\item{level_attributes_number}{The number of attributes assigned to level}
}
\value{
A date frame that contains the following columns: product_id, demand and attributes.
}
\description{
Simulate the demand and attributes for new products during their life cycle by
specifying their life cycle type of shape and providing information about
their attributes.
}
\examples{
npd_data_sim(products_number=100,
periods_number=30,
shape_number=5,
level_number=20)

npd_data_sim(products_number=100,
periods_number=20,
shape_number=5,
shape_type="bass",
level_number=20,
level_range=1000:10000,
noise_cv=0.05,
attribute_type="ind",
attributes_number=15,
shape_attributes_number=7,
level_attributes_number=5)


}
