% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_power_and_sample_size.R
\name{power_two_arm}
\alias{power_two_arm}
\title{Power}
\usage{
power_two_arm(
  arm0,
  arm1,
  test = list(test = "weighted logrank"),
  alpha = 0.025,
  sides = 1
)
}
\arguments{
\item{arm0}{object of class 'arm'.}

\item{arm1}{object of class 'arm'.}

\item{test}{list or list of lists. Each list must contain at minimum
the key 'test' describing the type of statistical test. Default test
is the "weighted logrank". Kaplan-Meier based tests ("survival difference",
"survival ratio", "rmst difference", "rmst ratio", "percentile difference",
and "percentile ratio") require the user to define an additional key,
either the desired 'milestone' or 'percentile'. The weighted log-rank test
does not require additional keys. However, user may choose which weight function
("1"=unweighted, "n"=Gehan-Breslow, "sqrtN"=Tarone-Ware, "FH_p[a]_q[b]"=
Fleming-Harrington with p=a and q=b) and which approximation for the
large-sample mean ("asymptotic", "generalized schoenfeld", "event driven",
"freedman", "rubinstein") and variance ("1", "block[ randomization]", "simple[ randomization]") 
they wish to use. Default choice is 'weight'="1", 'mean.approx'="asymptotic", and 'var.approx'="1".
For more details regarding the different mean and variance approximations
for the weight log-rank test, please see Yung and Liu (2020). If there are multiple lists, 
then users may provide a 'label' for each list to be displayed in the output.}

\item{alpha}{type 1 error rate}

\item{sides}{1=1-sided test, 2=2-sided test}
}
\value{
power.
}
\description{
Calculate power for a two-arm survival study.
}
\examples{
arm0 <- create_arm(size=120, accr_time=6, surv_scale=0.05, loss_scale=0.005, follow_time=12)
arm1 <- create_arm(size=120, accr_time=6, surv_scale=0.03, loss_scale=0.005, follow_time=12)
power_two_arm(arm0, arm1)
power_two_arm(arm0, arm1, list(test="weighted logrank",
  weight="n",
  mean.approx="generalized schoenfeld",
  var.approx="block"))
power_two_arm(arm0, arm1, list(test="survival difference", milestone=12))
power_two_arm(arm0, arm1, list(test="rmst ratio", milestone=12))
power_two_arm(arm0, arm1, list(test="percentile difference", percentile=0.25))
power_two_arm(arm0, arm1, list(
  list(test="weighted logrank", label="Logrank"),
  list(test="survival difference", milestone=12, label="12-month survival difference")))
}
\references{
Yung, G and Liu, Y. (2020). Sample size and power for the weighted
log-rank test and Kaplan-Meier based tests with allowance for non-proportional
hazards. \emph{Biometrics} 76(3):939-950.
}
\seealso{
\code{\link{create_arm}} for creating an object of class 'arm'.
}
