% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cnm.R
\name{dmix}
\alias{dmix}
\title{Density function of a mixture distribution}
\usage{
dmix(x, mix, beta = NULL, log = FALSE)
}
\arguments{
\item{x}{a data object of a mixture model class.}

\item{mix}{a discrete distribution, as defined by class
\code{disc}.}

\item{beta}{the structural parameter, if any.}

\item{log}{if \code{TRUE}, computes the log-values, or else just
the density values.}
}
\description{
Computes the density or their logarithmic values of a
  mixture distribution, where the component family depends on the
  class of \code{x}.

\code{x} must belong to a mixture family, as specified by its class.
}
\examples{

## Poisson mixture
mix0 = disc(c(1,4), c(0.7,0.3))
x = rnppois(10, mix0)
dmix(x, mix0)
dmix(x, mix0, log=TRUE)

## Normal mixture
x = rnpnorm(10, mix0, sd=1)
dmix(x, mix0, 1)
dmix(x, mix0, 1, log=TRUE)
dmix(x, mix0, 0.5, log=TRUE)

}
\references{
Wang, Y. (2007). On fast computation of the non-parametric maximum
likelihood estimate of a mixing distribution. \emph{Journal of the
Royal Statistical Society, Ser. B}, \bold{69}, 185-198.

Wang, Y. (2010). Maximum likelihood computation for fitting
semiparametric mixture models. \emph{Statistics and Computing},
\bold{20}, 75-86
}
\seealso{
\code{\link{cnm}}, \code{\link{cnmms}},
  \code{\link{npnorm}}, \code{\link{nppois}}, \code{\link{disc}},
}
\author{
Yong Wang <yongwang@auckland.ac.nz>
}
