% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/disc.R
\name{plot.disc}
\alias{plot.disc}
\title{Plot a discrete distribution function}
\usage{
\method{plot}{disc}(
  x,
  type = c("pdf", "cdf"),
  add = FALSE,
  col = 4,
  lwd = 1,
  ylim,
  xlab = "",
  ylab = "Probability",
  ...
)
}
\arguments{
\item{x}{an object of class \code{disc}.}

\item{type}{plot its pdf or cdf.}

\item{add}{add the plot or not.}

\item{col}{colour to be used.}

\item{lwd, ylim, xlab, ylab}{graphical parameters.}

\item{...}{arguments passed on to function \code{plot}.}
}
\description{
Class \code{disc} is used to represent an arbitrary
  univariate discrete distribution with a finite number of support
  points.

Function \code{disc} creates an object of class \code{disc}, given
 the support points and probability values at these points.

Function \code{plot.disc} plots the discrete distribution.
}
\examples{

plot(disc(pt=c(0,4), pr=c(0.3,0.7)))
plot(disc(rnorm(5), 1:5))
for(i in 1:5)
   plot(disc(rnorm(5), 1:5), type="cdf", add=(i>1), xlim=c(-3,3))

}
\seealso{
\code{\link{disc}}, \code{\link{cnm}}, \code{\link{cnmms}}.
}
\author{
Yong Wang <yongwang@auckland.ac.nz>
}
