% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nzffdr_import.R
\name{nzffdr_import}
\alias{nzffdr_import}
\title{Import NZ Freshwater Fish datasets.}
\usage{
nzffdr_import(
  institution = "",
  catchment_num = "",
  catchment_name = "",
  water_body = "",
  fish_method = "",
  taxon = "",
  starts = "",
  ends = "",
  download_format = "all"
)
}
\arguments{
\item{institution}{institution that collected the data. Use the
\code{nzffdr_get_table("institution")} function to see a list of all possible options,
or don't set the arg if you want all institutions in the database.}

\item{catchment_num}{catchment number. A 6 digit number unique to the reach of
interest. You can search using the individual number (e.g. \code{catchment =
"702.500"}), or for all rivers in a catchment you can use the wildcard
search term (e.g. \code{catchment = "702\%"}), or don't set the arg if you
want all catchments in the database.}

\item{catchment_name}{catchment name. e.g. \code{catchment_name = "Hinds R"}. 
Case sensitive. Don't set the arg if you want all catchments in the database.}

\item{water_body}{water body name. e.g. to get all records for Limestone
Creek, \code{water_body = "Limestone Creek"}. Don't set the arg if you
want all water bodies in the database.}

\item{fish_method}{fishing method used. Use the \code{nzffdr_get_table("fish_method")} 
function to see a list of all possible options. If you only want fish caught
be lures use \code{fish_meth = "Angling - Lure"}, don't set the arg if
you want all fishing methods in the database.}

\item{taxon}{taxon of interest. Use the \code{nzffdr_get_table("taxon")} function
to see a list of all possible options. You can search using either 
common or scientific names and can search for multiple taxon at 
once, e.g. to search for Black mudfish use \code{taxon = "Black mudfish"} 
or \code{taxon = "Neochanna diversus"} and to search for Black mudfish
and Bluegill bully use \code{taxon = c("Black mudfish", "Bluegill bully")} 
etc.}

\item{starts}{start year. Don't set the arg if
you want all records in the database.}

\item{ends}{end year. Don't set the arg if
you want all records in the database.}

\item{download_format}{use "all" or "essential" to download either, all 
variables (67 columns), which now includes some River Environment
Classification data, or just essential data (23 columns).}
}
\value{
A dataframe where each row is a NZFFD record.
}
\description{
Import data from the NZ Freshwater Fish Database. Enter search terms as 
arguments as you would in the NZFFD and import directly into R. You can 
search using all the same query options which are
used for in the \href{https://nzffdms.niwa.co.nz/search}{NZFFFD}, see their
\href{https://niwa.co.nz/information-services/nz-freshwater-fish-database}{info page} 
for details. To import the entire database leave all arguments as default.
}
\details{
This function requires an internet connection to query NIWA's database.

Data citation: Stoffels R (2022). New Zealand Freshwater Fish Database (extended).
The National Institute of Water and Atmospheric Research (NIWA).
Sampling event dataset https://doi.org/10.15468/jbpw92
}
\examples{
\dontrun{
# import entire NZFFD
dat <- nzffdr_import()
}
}
