% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/websocketAPIpublic.R
\name{websocketAPIpublic}
\alias{websocketAPIpublic}
\title{websocketAPIpublic Class}
\description{
Public channel of WebSocket API for \href{https://www.okx.com/docs-v5/en/}{Okx exchange v5 API}.
See \href{https://www.okx.com/docs-v5/en/#websocket-api-public-channel}{Public Channel} for more information.
}
\examples{
\dontrun{
tmp <- websocketAPIpublic$new()
tmp$connect()

# subscribe BTC-USDT-SWAP 5m candlesticks data
msg <- list(
  op = "unsubscribe",
  args = list(
    list(channel = "candle5m", instId = "BTC-USDT-SWAP")
  )
)
msg <- jsonlite::toJSON(msg, auto_unbox = TRUE, pretty = TRUE)
tmp$send(msg)

# pass your own callback function
tmp$on_message(function(event) {
  if (event$data == "pong") {
    cat("Bingo!!\n")
  }
})
tmp$send("ping")

tmp$close()
}

}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{channel}}{Public WebSocket url.}

\item{\code{simulate}}{Whether to use demo trading service.}

\item{\code{ws}}{A websocket::WebSocket object to establish a connection to the server.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-websocketAPIpublic-new}{\code{websocketAPIpublic$new()}}
\item \href{#method-websocketAPIpublic-connect}{\code{websocketAPIpublic$connect()}}
\item \href{#method-websocketAPIpublic-on_open}{\code{websocketAPIpublic$on_open()}}
\item \href{#method-websocketAPIpublic-on_close}{\code{websocketAPIpublic$on_close()}}
\item \href{#method-websocketAPIpublic-on_message}{\code{websocketAPIpublic$on_message()}}
\item \href{#method-websocketAPIpublic-on_error}{\code{websocketAPIpublic$on_error()}}
\item \href{#method-websocketAPIpublic-send}{\code{websocketAPIpublic$send()}}
\item \href{#method-websocketAPIpublic-close}{\code{websocketAPIpublic$close()}}
\item \href{#method-websocketAPIpublic-clone}{\code{websocketAPIpublic$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-websocketAPIpublic-new"></a>}}
\if{latex}{\out{\hypertarget{method-websocketAPIpublic-new}{}}}
\subsection{Method \code{new()}}{
Create a new websocketAPIpublic object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{websocketAPIpublic$new(simulate = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{simulate}}{Whether to use demo trading service.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-websocketAPIpublic-connect"></a>}}
\if{latex}{\out{\hypertarget{method-websocketAPIpublic-connect}{}}}
\subsection{Method \code{connect()}}{
Initiate the connection to the server.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{websocketAPIpublic$connect()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-websocketAPIpublic-on_open"></a>}}
\if{latex}{\out{\hypertarget{method-websocketAPIpublic-on_open}{}}}
\subsection{Method \code{on_open()}}{
Called when the connection is established.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{websocketAPIpublic$on_open(func)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{func}}{A Callback function.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-websocketAPIpublic-on_close"></a>}}
\if{latex}{\out{\hypertarget{method-websocketAPIpublic-on_close}{}}}
\subsection{Method \code{on_close()}}{
Called when a previously-opened connection is closed.
The event will have 'code' (integer) and 'reason' (one-element character)
elements that describe the remote's reason for closing.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{websocketAPIpublic$on_close(func)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{func}}{A Callback function.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-websocketAPIpublic-on_message"></a>}}
\if{latex}{\out{\hypertarget{method-websocketAPIpublic-on_message}{}}}
\subsection{Method \code{on_message()}}{
Called each time a message is received from the server.
The event will have a 'data' element, which is the message content.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{websocketAPIpublic$on_message(func)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{func}}{A Callback function.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-websocketAPIpublic-on_error"></a>}}
\if{latex}{\out{\hypertarget{method-websocketAPIpublic-on_error}{}}}
\subsection{Method \code{on_error()}}{
Called when the connection fails to be established.
The event will have an 'message' element, a character vector of length 1
describing the reason for the error.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{websocketAPIpublic$on_error(func)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{func}}{A Callback function.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-websocketAPIpublic-send"></a>}}
\if{latex}{\out{\hypertarget{method-websocketAPIpublic-send}{}}}
\subsection{Method \code{send()}}{
Send a message to the server.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{websocketAPIpublic$send(msg)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{msg}}{Messages.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-websocketAPIpublic-close"></a>}}
\if{latex}{\out{\hypertarget{method-websocketAPIpublic-close}{}}}
\subsection{Method \code{close()}}{
Close the connection.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{websocketAPIpublic$close()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-websocketAPIpublic-clone"></a>}}
\if{latex}{\out{\hypertarget{method-websocketAPIpublic-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{websocketAPIpublic$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
