% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_impute.R
\name{handle_missing_values}
\alias{handle_missing_values}
\title{Handle Missing Values in a Tibble}
\usage{
handle_missing_values(
  data,
  threshold = 0.2,
  imputation_method = "half_min",
  metadata_cols = NULL
)
}
\arguments{
\item{data}{A tibble containing the data with potential missing values.}

\item{threshold}{A numeric value between 0 and 1 representing the maximum allowable proportion of missing values in a feature. Default is 0.20.}

\item{imputation_method}{A character string indicating the method to use for imputation. Valid methods are "mean", "median", "mode", and "half_min". Default is "mean".}

\item{metadata_cols}{A vector of column names or indices to be treated as metadata, exempt from filtering and imputation. Default is NULL.}
}
\value{
A tibble with filtered features and imputed missing values.
}
\description{
This function filters features based on a missing value threshold and imputes missing values using various methods.
Metadata columns are specified by the user and are exempt from filtering and imputation.
}
\examples{
data <- tibble::tibble(
  Feature1 = c(1, 2, NA, 4, 5),
  Feature2 = c(NA, 2, 3, 4, NA),
  Feature3 = c(1, NA, 3, NA, 5),
  Metadata = c("A", "B", "C", "D", "E")
)
imputed_data <- handle_missing_values(
  data,
  threshold = 0.20,
  imputation_method = "half_min",
  metadata_cols = "Metadata"
)
print(imputed_data)
}
\author{
Yaoxiang Li
}
