% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_normalize.R
\name{qc_normalize}
\alias{qc_normalize}
\title{QC-RLSC Normalize function}
\usage{
qc_normalize(data, qc_label = "QC", sample_id_col = "sample_id")
}
\arguments{
\item{data}{A data frame containing the sample data. The first column
should contain the sample identifiers by default named 'sample_id', and the rest of the columns
contain the peaks to be normalized. QC samples should be indicated
in the sample identifiers with 'QC'.}

\item{qc_label}{A string indicating the label used for QC samples. Default is 'QC'.}

\item{sample_id_col}{A string indicating the column name used for sample identifiers. Default is 'sample_id'.}
}
\value{
A data frame with the first column as the sample identifiers and
the rest of the columns containing the normalized peak intensities.
}
\description{
This function performs normalization on the input data matrix using
the robust loess signal correction (RLSC) method. Normalization is based on
Quality Control (QC) samples in the data.
}
\examples{
# Load the CSV data
data_file <- system.file("extdata", "example2.csv", package = "omicsTools")
data <- readr::read_csv(data_file)

# Display the first few rows of the original data
print(head(data))

# Apply the qc_rlsc_normalize function
normalized_data <- qc_normalize(data, qc_label = "QC", sample_id_col = "Sample")

# Display the first few rows of the normalized data
print(head(normalized_data))

\donttest{
# Write the normalized data to a new CSV file
readr::write_csv(normalized_data, paste0(tempdir(), "/normalized_data.csv"))
}
}
\author{
Yaoxiang Li
}
