% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/onc.R
\docType{class}
\name{Onc-class}
\alias{Onc-class}
\alias{Onc}
\title{Onc Class}
\arguments{
\item{token}{User token}

\item{production}{whether the ONC Production server URL is used for service requests}

\item{showInfo}{Whether verbose debug messages are displayed}

\item{outPath}{Output path for downloaded files}

\item{timeout}{Number of seconds before a request to the API is canceled}
}
\description{
Provides convenient & easy access to Ocean Networks Canada's data.
For detailed information and usage examples, visit our
\href{https://wiki.oceannetworks.ca/display/O2A/Oceans+2.0+API+Home}{official Documentation}.
}
\section{Fields}{

\describe{
\item{\code{token}}{character. User token}

\item{\code{showInfo}}{logical. Print verbose debug comments}

\item{\code{timeout}}{numeric. Number of seconds before a request to the API is canceled}

\item{\code{baseUrl}}{character. Base URL for API requests}

\item{\code{outPath}}{character. Output path for downloaded files

Class initializer}
}}

\section{Methods}{

\describe{
\item{\code{downloadDataProduct(
  runId = 0,
  maxRetries = 0,
  downloadResultsOnly = FALSE,
  includeMetadataFile = TRUE,
  overwrite = FALSE
)}}{Manually download a data product after it was requested and run}

\item{\code{formatUtc(dateString = "now")}}{Formats the provided date string to meet ISO8601}

\item{\code{getDataProducts(filters = list())}}{Returns a filtered list of data products}

\item{\code{getDeployments(filters = list())}}{Returns a filtered list of deployments}

\item{\code{getDeviceCategories(filters = list())}}{Returns a filtered list of device categories}

\item{\code{getDevices(filters = list())}}{Returns a filtered list of devices}

\item{\code{getDirectByDevice(filters = list(), allPages = FALSE)}}{Obtain scalar data readings from a device}

\item{\code{getDirectByLocation(filters = list(), allPages = FALSE)}}{Obtain scalar data readings from a device category in a location}

\item{\code{getDirectFiles(filters = list(), overwrite = FALSE, allPages = FALSE)}}{Download a list of archived files that match the filters provided}

\item{\code{getDirectRawByDevice(filters = list(), allPages = FALSE)}}{Obtain raw data readings from a device}

\item{\code{getDirectRawByLocation(filters = list(), allPages = FALSE)}}{Obtain raw data readings from a device category in a location}

\item{\code{getFile(filename = "", overwrite = FALSE)}}{Download a file with the given filename}

\item{\code{getListByDevice(filters = list(), allPages = FALSE)}}{Get a list of archived files for a device}

\item{\code{getListByLocation(filters = list(), allPages = FALSE)}}{Get a list of archived files for a device category in a location}

\item{\code{getLocationHierarchy(filters = list())}}{Returns a filtered locations tree}

\item{\code{getLocations(filters = list())}}{Returns a filtered list of locations}

\item{\code{getProperties(filters = list())}}{Returns a filtered list of properties}

\item{\code{orderDataProduct(
  filters = list(),
  maxRetries = 0,
  downloadResultsOnly = FALSE,
  includeMetadataFile = TRUE,
  overwrite = FALSE
)}}{Request, run and download a data product}

\item{\code{print(data, filename = "")}}{Prints a named list in a format easier to read}

\item{\code{requestDataProduct(filters = list())}}{Manually Request a data product}

\item{\code{runDataProduct(dpRequestId = 0, waitComplete = FALSE)}}{Manually run a data product request}
}}

