% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scaling_functions.R
\name{lb2kg}
\alias{lb2kg}
\alias{lb2mt}
\alias{kg2lb}
\alias{kg2_1000lb}
\alias{kg2mt}
\alias{inch2mm}
\alias{inch2cm}
\alias{mm2inch}
\alias{cm2inch}
\alias{divide_1000}
\alias{divide_100}
\alias{divide_10}
\alias{multiply_1000}
\alias{multiply_100}
\alias{multiply_10}
\title{Convert numeric values to a different scale}
\usage{
lb2kg(x)

lb2mt(x)

kg2lb(x)

kg2_1000lb(x)

kg2mt(x)

inch2mm(x)

inch2cm(x)

mm2inch(x)

cm2inch(x)

divide_1000(x)

divide_100(x)

divide_10(x)

multiply_1000(x)

multiply_100(x)

multiply_10(x)
}
\arguments{
\item{x}{A vector of numeric values}
}
\value{
The vector of numeric values converted to the appropriate scale
}
\description{
Convert numeric values to a different scale
}
\section{Functions}{
\itemize{
\item \code{lb2kg()}: Convert from pounds to kilograms

\item \code{lb2mt()}: Convert from pounds to metric tons

\item \code{kg2lb()}: Convert from kilograms to pounds

\item \code{kg2_1000lb()}: Convert from kilograms to 1000 pounds

\item \code{kg2mt()}: Convert from kilograms to metric tons

\item \code{inch2mm()}: Convert from inches to millimeters

\item \code{inch2cm()}: Convert from inches to centimeters

\item \code{mm2inch()}: Convert from millimeters to inches

\item \code{cm2inch()}: Convert from centimeters to inches

\item \code{divide_1000()}: Divide values by 1000

\item \code{divide_100()}: Divide values by 100

\item \code{divide_10()}: Divide values by 10

\item \code{multiply_1000()}: Multiply values by 1000

\item \code{multiply_100()}: Multiply values by 100

\item \code{multiply_10()}: Multiply values by 10

}}
\examples{
lb2kg(1:10)
kg2lb(1:10)
}
