% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CreateOpenBankingClient.R
\name{.openBankingClient}
\alias{.openBankingClient}
\title{initialize}
\description{
initialize

initialize
}
\keyword{internal}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{BankDetails}}{Details for available banks that support the API}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{.openBankingClient$new()}}
\item \href{#method-GetAvailableBanks}{\code{.openBankingClient$GetAvailableBanks()}}
\item \href{#method-GetAvailableInstruments}{\code{.openBankingClient$GetAvailableInstruments()}}
\item \href{#method-GetRawData}{\code{.openBankingClient$GetRawData()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Initialize a new API client
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.openBankingClient$new(
  bankDetails = "default",
  version = "latest",
  timeOutSeconds = 15
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{bankDetails}}{optional. Bank details list to use. When set to "default", the
bank details will be taken from the below URL:
https://github.com/OpenBankingUK/opendata-api-spec-compiled/blob/master/participant_store.json
Otherwise, the user can provide a custom list of bank details.}

\item{\code{version}}{optional. Which version of the API to use. Defaults to "latest.
When set to "latest", the version used will be the latest available for 
the selected bank and instrument. This information will be derived from the bank details table above.
Alternatively, the user can supply a manually set version such as "v2.3"}

\item{\code{timeOutSeconds}}{optional. Number of seconds before a request times out. Defaults to 15 seconds}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Object of type OpenBankingClient with methods for querying the API
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GetAvailableBanks"></a>}}
\if{latex}{\out{\hypertarget{method-GetAvailableBanks}{}}}
\subsection{Method \code{GetAvailableBanks()}}{
Get available banks that support the API
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.openBankingClient$GetAvailableBanks()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
character list. Names of available banks
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GetAvailableInstruments"></a>}}
\if{latex}{\out{\hypertarget{method-GetAvailableInstruments}{}}}
\subsection{Method \code{GetAvailableInstruments()}}{
Get available instruments for the API
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.openBankingClient$GetAvailableInstruments()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
character list. Names of available instruments
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GetRawData"></a>}}
\if{latex}{\out{\hypertarget{method-GetRawData}{}}}
\subsection{Method \code{GetRawData()}}{
Get raw data for a specified bank and instrument
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.openBankingClient$GetRawData(bankName, instrument)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{bankName}}{character. Name of the bank to get data for. See GetAvailableBanks()}

\item{\code{instrument}}{character. Instrument to get data for. See GetAvailableInstruments()}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
list. Raw data for the requested bank and instrument
}
}
}
