% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_dataset.R
\name{get_dataset}
\alias{get_dataset}
\title{Download ESM dataset(s) from openESM repository}
\usage{
get_dataset(
  dataset_id,
  version = "latest",
  cache = TRUE,
  path = NULL,
  force_download = FALSE,
  sandbox = FALSE,
  quiet = FALSE,
  max_attempts = 15,
  ...
)
}
\arguments{
\item{dataset_id}{Character string or vector of dataset IDs. Use
\code{\link[=list_datasets]{list_datasets()}} to see available datasets.}

\item{version}{Character string specifying the dataset version. Default is
"latest" which downloads the most recent version.}

\item{cache}{Logical. If \code{TRUE} (default), uses cached version if
available and not expired.}

\item{path}{Character string specifying custom download path. If \code{NULL}
(default), files are cached in the user's cache directory.}

\item{force_download}{Logical. If \code{TRUE}, forces re-download even if
cached version exists. Default is \code{FALSE}.}

\item{sandbox}{Logical. If \code{TRUE}, uses Zenodo sandbox environment
for testing. Default is \code{FALSE}.}

\item{quiet}{Logical. If \code{TRUE}, suppresses informational messages.
Default is \code{FALSE}.}

\item{max_attempts}{Integer, maximum number of retry attempts for Zenodo API calls. Default is 15.}

\item{...}{Additional arguments passed to \code{\link[=list_datasets]{list_datasets()}}.
This includes \code{metadata_version} to specify the metadata catalog version.}
}
\value{
For single dataset: An S3 object of class \code{openesm_dataset}
containing:
\itemize{
\item \code{data}: A tibble with the ESM data
\item \code{metadata}: List with dataset metadata
\item \code{dataset_id}: Character string with dataset identifier
\item \code{dataset_version}: Character string with dataset version number
\item \code{metadata_version}: Character string with metadata catalog version
}
For multiple datasets: An S3 object of class \code{openesm_dataset_list}
containing a named list of \code{openesm_dataset} objects.
}
\description{
Downloads one or more Experience Sampling Method (ESM) datasets from the
openESM repository hosted on Zenodo. Returns an S3 object containing the
dataset and associated metadata.
}
\details{
This function downloads ESM datasets from Zenodo using DOIs stored in the
openESM metadata repository. Datasets are cached locally to avoid repeated
downloads. Use \code{force_download = TRUE} to refresh cached data.

The function handles both individual datasets and batch downloads. When
downloading multiple datasets, progress is shown for each download.
}
\examples{
\donttest{
# List available datasets first
available <- list_datasets()
head(available)

# Download a single dataset
dataset <- get_dataset("0001")

# Access the data
head(dataset$data)

# View metadata and provenance information
dataset$metadata
dataset$dataset_version  # Dataset version
dataset$metadata_version # Metadata catalog version

# Download multiple datasets
datasets <- get_dataset(c("0001", "0002"))

# Access individual datasets from the list
datasets[["0001"]]$data

# Use specific metadata catalog version
dataset_v1 <- get_dataset("0001", metadata_version = "1.0.0")

# Force re-download to get latest version
dataset_fresh <- get_dataset("0001", force_download = TRUE)


\dontshow{
# cleanup
clear_cache(force = TRUE)
}
}

}
\seealso{
\code{\link[=list_datasets]{list_datasets()}} for available datasets,
\code{\link[=cite]{cite()}} for citation information
}
