% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-LAhomes.R
\docType{data}
\name{LAhomes}
\alias{LAhomes}
\title{LAhomes}
\format{
A data frame with 1594 observations on the following 8 variables.
\describe{
\item{city}{City where the home is located.}
\item{type}{Type of home with levels \code{Condo/Twh} - condo or townhouse, \code{SFR} - single family residence, and \code{NA}}
\item{bed}{Number of bedrooms in the home.}
\item{bath}{Number of bathrooms in the home.}
\item{garage}{Number of cars that can be parked in the garage. Note that a value of \code{4} refers to 4 or more garage spaces.}
\item{sqft}{Squarefootage of the home.}
\item{pool}{Indicates if the home has a pool.}
\item{price}{Listing price of the home.}
}
}
\usage{
LAhomes
}
\description{
Data collected by Andrew Bray at Reed College on characteristics of LA Homes in 2010.
}
\examples{

library(ggplot2)

ggplot(LAhomes, aes(sqft, price)) +
  geom_point(alpha = 0.2) +
  theme_minimal() +
  labs(
    title = "Can we predict list price from squarefootage?",
    subtitle = "Homes in the Los Angeles area",
    x = "Square feet",
    y = "List price"
  )
}
\keyword{datasets}
