% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-infmortrate.R
\docType{data}
\name{infmortrate}
\alias{infmortrate}
\title{Infant Mortality Rates, 2012}
\format{
A data frame with 222 observations on the following 2 variables.
\describe{
\item{country}{Name of country.}
\item{inf_mort_rate}{Infant mortality rate per 1,000 live births.}
}
}
\source{
CIA World Factbook,
\url{https://www.cia.gov/the-world-factbook/field/infant-mortality-rate/country-comparison}.
}
\usage{
infmortrate
}
\description{
This entry gives the number of deaths of infants under one year old in 2012
per 1,000 live births in the same year. This rate is often used as an
indicator of the level of health in a country.
}
\details{
The data is given in decreasing order of infant mortality rates. There are a
few potential outliers.
}
\examples{

library(ggplot2)

ggplot(infmortrate, aes(x = inf_mort_rate)) +
  geom_histogram(binwidth = 10)

ggplot(infmortrate, aes(x = inf_mort_rate)) +
  geom_density()
}
\keyword{datasets}
\keyword{distribution}
\keyword{histogram}
