% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opt_style.R
\name{opt_style}
\alias{opt_style}
\alias{styles}
\title{Get or set the optigrab style}
\usage{
opt_style(style)
}
\arguments{
\item{style}{named list; containing the following functions:
\code{flag_test}, \code{flag_to_name} and \code{name_to_flag}

If \code{style} is not specified, \code{opt_style} gets the current optigrab
style. If \code{style} is provided, it must be a named list containing 
three functions \code{flag_test}, \code{flag_to_name} and 
\code{name_to_flag}.}
}
\value{
If \code{style} is not provided, returns a list of styles, otherwise used
for the side-effect of setting the option
}
\description{
Get or sets the optigrab style
}
\section{flag_test}{


Accepts a character vector and returns a logical vector indicating whether 
the elements are flags.
}

\section{flag_to_name}{
 

Accepts a character vector of flags and turns them into variable names, 
usually by stripping delimiters that indicate that they are flags
}

\section{name_to_flag}{


Accepts a character vector of names and transforms them into the flags that
would appear on the command line. This is used by \code{\link[=opt_grab]{opt_grab()}}.
}

\examples{
  opt_style() 
  opt_style( optigrab:::gnu_style )
  opt_style( optigrab:::java_style )
  opt_style( optigrab:::ms_style )
  
}
\seealso{
\link{gnu_style}, \link{java_style} or \link{ms_style}
}
