% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optional.R
\name{match_with}
\alias{match_with}
\title{Match With}
\usage{
match_with(x, ...)
}
\arguments{
\item{x}{The variable to pattern-match}

\item{...}{Pairs of one pattern (value or list or magrittr 
sequence) and one result function}
}
\description{
Function to check a variable using pattern matching.
}
\details{
\code{match_with(variable,
pattern, result-function,
...}
If \code{variable} matches a \code{pattern}, \code{result-function}
is called. For comparing optional types, it is a better habit to 
use \code{match_with} than a conditional statement.

\enumerate{
  \item Each \code{pattern} can be either:
    \itemize{
      \item an object or a primitive type (direct comparison with \code{variable}),
      \item a list (match if \code{variable} is in the list),
      \item a \code{magrittr} functional sequence that matches if it returns \code{variable} . The dot \code{.} denotes the variable to be matched.
    }
  \item If \code{result-function} takes no arguments, it will be called as is. Else, the only argument that will be sent is \code{variable}. 
  You can also use the fallthrough function \code{fallthrough()} to permit the matching to continue even if the current pattern is matched.
}
}
\examples{
library(magrittr)

a <- 5
match_with(a,
  . \%>\% option(.),     paste,
  none, function()   "Error!"
)
## [1] 5

match_with(a,
  1,                   function()  "Matched exact value",
  list(2, 3, 4),       function(x) paste("Matched in list:", x),
  . \%>\% if (. > 4) .,  function(x) paste("Matched in condition:", x)
)
## [1] "Matched in condition: 5"
}
\seealso{
option(), none
}
