% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dt.R
\name{orbital_dt}
\alias{orbital_dt}
\title{Convert to data.table code}
\usage{
orbital_dt(x)
}
\arguments{
\item{x}{An \link{orbital} object.

This function requires \href{https://dtplyr.tidyverse.org/}{dtplyr} to be
installed to run. The resulting code will likely need to be adopted to your
use-case. Most likely by removing the initial \code{copy(data-name)} at the start.}
}
\value{
data.table code.
}
\description{
Returns \href{https://rdatatable.gitlab.io/data.table/}{data.table} code that
is equivilant to prediction code.
}
\examples{
\dontshow{if (rlang::is_installed(c("dbplyr", "dtplyr", "recipes", "tidypredict", "workflows"))) withAutoprint(\{ # examplesIf}

library(workflows)
library(recipes)
library(parsnip)

rec_spec <- recipe(mpg ~ ., data = mtcars) |>
  step_normalize(all_numeric_predictors())

lm_spec <- linear_reg()

wf_spec <- workflow(rec_spec, lm_spec)

wf_fit <- fit(wf_spec, mtcars)

orbital_obj <- orbital(wf_fit)

orbital_dt(orbital_obj)
\dontshow{\}) # examplesIf}
}
