% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ordinal_cohens_kappa.R
\encoding{UTF-8}
\name{ordinal_cohens_kappa}
\alias{ordinal_cohens_kappa}
\title{Computes the estimated ordinal Cohen's kappa of an ordinal time series}
\usage{
ordinal_cohens_kappa(series, states, distance = "Block", lag = 1)
}
\arguments{
\item{series}{An OTS.}

\item{states}{A numerical vector containing the corresponding
states.}

\item{distance}{A function defining the underlying distance between
states. The Hamming, block and Euclidean distances are already
implemented by means of the arguments "Hamming", "Block" (default)
and "Euclidean". Otherwise, a function taking as input two states must
be provided.}

\item{lag}{The considered lag.}
}
\value{
The estimated ordinal Cohen's kappa.
}
\description{
\code{ordinal_cohens_kappa} computes the estimated ordinal Cohen's kappa
of an ordinal time series
}
\details{
Given an OTS of length \eqn{T} with range \eqn{\mathcal{S}=\{s_0, s_1, s_2, \ldots, s_n\}} (\eqn{s_0 < s_1 < s_2 < \ldots < s_n}),
\eqn{\overline{X}_t=\{\overline{X}_1,\ldots, \overline{X}_T\}}, the function computes the
estimated ordinal Cohen's kappa given by \eqn{\widehat{\kappa}_d(l)=\frac{\widehat{disp}_d(X_t)-\widehat{E}[d(X_t, X_{t-l})]}{{\widehat{disp}}_d(X_t)}},
where \eqn{\widehat{disp}_{d}(X_t)=\frac{T}{T-1}\sum_{i,j=0}^nd\big(s_i, s_j\big)\widehat{p}_i\widehat{p}_j} is the DIVC estimate of the dispersion, with
\eqn{d(\cdot, \cdot)} being a distance between ordinal states and \eqn{\widehat{p}_k} being the
standard estimate of the marginal probability for state \eqn{s_k},
and \eqn{\widehat{E}[d(X_t, X_{t-l})]=\frac{1}{T-l} \sum_{t=l+1}^T d(\overline{X}_t, \overline{X}_{t-l})}.
}
\examples{
estimated_ock <- ordinal_cohens_kappa(series = AustrianWages$data[[100]],
states = 0 : 5) # Computing the estimated ordinal Cohen's kappa
# for one series in dataset AustrianWages using the block distance
}
\references{
{

  \insertRef{weiss2019distance}{otsfeatures}

}
}
\author{
Ángel López-Oriona, José A. Vilar
}
