% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ordinal_location_1.R
\encoding{UTF-8}
\name{ordinal_location_1}
\alias{ordinal_location_1}
\title{Computes the standard estimated location of an ordinal time series}
\usage{
ordinal_location_1(series, states, distance = "Block", normalize = FALSE)
}
\arguments{
\item{series}{An OTS.}

\item{states}{A numerical vector containing the corresponding
states.}

\item{distance}{A function defining the underlying distance between
states. The Hamming, block and Euclidean distances are already
implemented by means of the arguments "Hamming", "Block" (default)
and "Euclidean". Otherwise, a function taking as input two states must
be provided.}

\item{normalize}{Logical. If \code{normalize = FALSE} (default), the value of the standard estimated location is returned. Otherwise, the function
returns the normalized standard estimated location.}
}
\value{
The standard estimated location.
}
\description{
\code{ordinal_location_1} computes the standard estimated location
of an ordinal time series
}
\details{
Given an OTS of length \eqn{T} with range \eqn{\mathcal{S}=\{s_0, s_1, s_2, \ldots, s_n\}} (\eqn{s_0 < s_1 < s_2 < \ldots < s_n}),
\eqn{\overline{X}_t=\{\overline{X}_1,\ldots, \overline{X}_T\}}, the function computes the standard
estimated location given by \eqn{\widehat{x}_{loc, d}=}argmin\eqn{_{s \in \mathcal{S}}\frac{1}{T}\sum_{t=1}^Td\big(\overline{X}_t, s\big)},
where \eqn{d(\cdot, \cdot)} is a distance between ordinal states.
}
\examples{
estimated_location <- ordinal_location_1(series = AustrianWages$data[[100]],
states = 0 : 5) # Computing the standard location estimate
# for one series in dataset AustrianWages using the block distance
}
\references{
{

  \insertRef{weiss2019distance}{otsfeatures}

}
}
\author{
Ángel López-Oriona, José A. Vilar
}
