% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_ordinal_dispersion.R
\encoding{UTF-8}
\name{test_ordinal_dispersion}
\alias{test_ordinal_dispersion}
\title{Performs the hypothesis test associated with the
ordinal dispersion for the block distance}
\usage{
test_ordinal_dispersion(
  series,
  states,
  true_dispersion,
  alpha = 0.05,
  temporal = TRUE,
  max_lag = 1
)
}
\arguments{
\item{series}{An OTS (numerical vector with integers).}

\item{states}{A numeric vector containing the corresponding
states.}

\item{true_dispersion}{The value for the true dispersion.}

\item{alpha}{The significance level (default is 0.05).}

\item{temporal}{Logical. If \code{temporal = TRUE} (default), the test is performed for a time series. Otherwise,
the test is performed for i.i.d. data.}

\item{max_lag}{If \code{temporal = TRUE}, the maximum considered lag to compute the
estimates related to the cumulative joint probabilities.}
}
\value{
The results of the hypothesis test.
}
\description{
\code{test_ordinal_dispersion} performs the hypothesis test associated with the
ordinal dispersion for the block distance
}
\details{
If \code{temporal = TRUE} (default), the function performs the hypothesis test based on the
ordinal dispersion relying on Theorem 7.1.1 in \insertCite{weiss2019distance;textual}{otsfeatures}. Otherwise,
the test based on Theorem 4.1 in \insertCite{weiss2019distance;textual}{otsfeatures} is carried out.
}
\examples{
results_test <- test_ordinal_dispersion(AustrianWages$data[[100]],
states = 0 : 5, true_dispersion = 2) # Performing the hypothesis test associated with the
# ordinal dispersion for one OTS in dataset AustrianWages
}
\references{
{

  \insertRef{weiss2019distance}{otsfeatures}

}
}
\author{
Ángel López-Oriona, José A. Vilar
}
