% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eligibility_rate.R
\name{eligibility_rate}
\alias{eligibility_rate}
\title{Survey Eligibility Rate}
\usage{
eligibility_rate(x, weight = NULL)
}
\arguments{
\item{x}{a character vector of disposition outcomes (I, P, R, NC, O, UH, UO,
U, or NE). Alternatively, a named vector/table of (weighted) disposition
counts.}

\item{weight}{an optional numeric vector that specifies the weight of each
element in 'x' if x is a character vector. If none is provided (the
default), an unweighted estimate is returned.}
}
\description{
Provides an estimate for the proportion of cases of unknown eligibility
that are eligible, as described by \insertCite{vdk}{outcomerate}. The
rate is typically (but not necessarily) calculated on the screener data
or other sources depending on the type of survey, and approaches to
calculating 'e' may therefore differ from one survey to the next.
}
\details{
The present implementation follows the default used in the Excel-based \emph{AAPOR
Outcome Rate Calculator (Version 4.0, May, 2016)} on the basis of
known ineligibles being coded as "NE".

The eligibility rate (ELR) is defined as
\itemize{
\item ELR = (I + P + R + NC + O) / (I + P + R + NC + O + NE)
}
}
\examples{
# load the outcomerate package
library(outcomerate)

# Create a vector of survey dispositions
#
# I  = Complete interview
# P  = Partial interview
# R  = Refusal and break-off
# NC = Non-contact
# O  = Other
# UH = Unknown if household/occupied housing unit
# UO = Unknown, other
# NE = Not eligible
x <- c("I", "P", "I", "NE", "NC", "UH", "I", "R", "UO", "I", "O", "P", "I")

# calculate all rates, assume 80\% of unknown cases are elligble
eligibility_rate(x)

# calculate weighted rates
w <- runif(13, 0, 5)
eligibility_rate(x, weight = w)

# alternatively, provide input as counts
freq <- c(I = 6, P = 2, NC = 3, NE = 1)
eligibility_rate(freq)

}
\references{
\insertRef{aapor}{outcomerate} \insertAllCited
}
\seealso{
\link{outcomerate}
}
