% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pr2ncdbias.R
\name{pr2ncdbias}
\alias{pr2ncdbias}
\title{bias and std error for (kd,ky) using partial R2-based analysis without conditioning on treatment}
\usage{
pr2ncdbias(kd, ky, alpha, data, outcome, treatment, bnch_reg, other_reg = NULL)
}
\arguments{
\item{kd}{sensitivity parameter kD (scalar)}

\item{ky}{sensitivity parameter kY (scalar)}

\item{alpha}{significance level for hypothesis test (e.g. 0.05)}

\item{data}{data frame for analysis}

\item{outcome}{name of outcome variable}

\item{treatment}{name of treatment variable}

\item{bnch_reg}{name(s) of benchmark covariate(s)}

\item{other_reg}{name(s) of other covariate(s)}
}
\value{
a list with the following elements:
\item{adjestp}{Adj std error when unadj estimate>0}
\item{adjestn}{Adj std error when unadj estimate<0}
\item{cilbp}{Adj lower boundary of conf int when unadj estimate>0}
\item{ciubp}{Adj upper boundary of conf int when unadj estimate>0}
\item{cilbn}{Adj lower boundary of conf int when unadj estimate<0}
\item{ciubn}{Adj upper boundary of conf int when unadj estimate<0}
}
\description{
bias and std error for (kd,ky) using partial R2-based analysis without conditioning on treatment
}
\examples{
require("sensemakr")
Y <- "peacefactor"
D <- "directlyharmed"
X <- "female"
X_oth <- c("village","age","farmer_dar","herder_dar","pastvoted","hhsize_darfur")


res4<-pr2ncdbias(kd=1,ky=1,alpha=0.05,data=darfur,outcome=Y,treatment=D,bnch_reg=X,other_reg=X_oth)

}
