% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_costeffectiveness.R
\name{calculate_ceac}
\alias{calculate_ceac}
\title{Calculate cost-effectiveness probabilities for two strategies.}
\usage{
calculate_ceac(
  df,
  e_int,
  e_comp,
  c_int,
  c_comp,
  v_wtp = seq(from = 0, to = 1e+05, by = 1000)
)
}
\arguments{
\item{df}{a dataframe.}

\item{e_int}{character. Name of variable of the dataframe containing total effects of the intervention strategy.}

\item{e_comp}{character. Name of variable of the dataframe containing total effects of the comparator strategy.}

\item{c_int}{character. Name of variable of the dataframe containing total costs of the intervention strategy.}

\item{c_comp}{character. Name of variable of the dataframe containing total costs of the comparator strategy.}

\item{v_wtp}{vector of numerical values. Vector of willingness-to-pay threshold for which the probabilities of cost effectiveness have to be defined. Default is 0:100,000 by increments of 1,000.}
}
\value{
A dataframe with three columns:
\itemize{
   \item WTP_threshold = The willingness-to-pay thresholds at which the probability of cost effectiveness has been calculated for both strategies
   \item Prob_int = The probability that the intervention strategy is cost effective at a given willingness-to-pay threshold
   \item Prob_comp = The probability that the comparator strategy is cost effective at a given willingness-to-pay threshold
   }
}
\description{
This function calculates the probabilities that each strategy is the cost effective at different willingness to pay thresholds.
}
\examples{
# Calculate probabilities of cost effectiveness using the example dataframe,
# for willlingness-to-pay thresholds of 0 to 50,0000 euros.
data("df_pa")
calculate_ceac(df = df_pa,
               e_int = "t_qaly_d_int",
               e_comp = "t_qaly_d_comp",
               c_int = "t_costs_d_int",
               c_comp = "t_costs_d_comp",
               v_wtp = seq(from = 0, to = 50000, by = 1000))
}
