% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survival_reg_flexsurv.R
\name{details_survival_reg_flexsurv}
\alias{details_survival_reg_flexsurv}
\title{Parametric survival regression}
\description{
\code{\link[flexsurv:flexsurvreg]{flexsurv::flexsurvreg()}} fits a parametric survival model.
}
\details{
For this engine, there is a single mode: censored regression
\subsection{Tuning Parameters}{

This model has 1 tuning parameters:
\itemize{
\item \code{dist}: Distribution (type: character, default: ‘weibull’)
}
}

\subsection{Translation from parsnip to the original package}{

The \strong{censored} extension package is required to fit this model.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(censored)

survival_reg(dist = character(1)) |> 
  set_engine("flexsurv") |> 
  set_mode("censored regression") |> 
  translate()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Parametric Survival Regression Model Specification (censored regression)
## 
## Main Arguments:
##   dist = character(1)
## 
## Computational engine: flexsurv 
## 
## Model fit template:
## flexsurv::flexsurvreg(formula = missing_arg(), data = missing_arg(), 
##     weights = missing_arg(), dist = character(1))
}\if{html}{\out{</div>}}
}

\subsection{Other details}{

The main interface for this model uses the formula method since the
model specification typically involved the use of
\code{\link[survival:Surv]{survival::Surv()}}.

For this engine, stratification cannot be specified via
\code{\link[survival:strata]{survival::strata()}}, please see
\code{\link[flexsurv:flexsurvreg]{flexsurv::flexsurvreg()}} for alternative
specifications.

Predictions of type \code{"time"} are predictions of the mean survival time.
}

\subsection{Case weights}{

This model can utilize case weights during model fitting. To use them,
see the documentation in \link{case_weights} and the examples
on \code{tidymodels.org}.

The \code{fit()} and \code{fit_xy()} arguments have arguments called
\code{case_weights} that expect vectors of case weights.
}

\subsection{Saving fitted model objects}{

This model object contains data that are not required to make
predictions. When saving the model for the purpose of prediction, the
size of the saved object might be substantially reduced by using
functions from the \href{https://butcher.tidymodels.org}{butcher} package.
}

\subsection{Prediction types}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{parsnip:::get_from_env("survival_reg_predict") |>
  dplyr::filter(engine == "flexsurv") |>
  dplyr::select(mode, type)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## # A tibble: 5 x 2
##   mode                type       
##   <chr>               <chr>      
## 1 censored regression time       
## 2 censored regression quantile   
## 3 censored regression hazard     
## 4 censored regression survival   
## 5 censored regression linear_pred
}\if{html}{\out{</div>}}
}

\subsection{References}{
\itemize{
\item Jackson, C. 2016. \code{flexsurv}: A Platform for Parametric Survival
Modeling in R. \emph{Journal of Statistical Software}, 70(8), 1 - 33.
}
}
}
\keyword{internal}
